<?php
require_once __DIR__ . '/settings.php';

function fetchData($id = 0, $page = 1) {
    global $dramaApi, $language;
    $endpointPage = $page == 1 ? 0 : $page;
    $endpoint = $dramaApi . "/" . $language . "/genres/$id/$endpointPage.json";
    $response = file_get_contents($endpoint);
    return json_decode($response, true);
}

$urlPath = explode('/', trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/'));
$id = isset($urlPath[1]) && is_numeric($urlPath[1]) ? (int)$urlPath[1] : 0;
$currentId = isset($urlPath[2]) && is_numeric($urlPath[2]) ? (int)$urlPath[2] : 1;

$data = fetchData($id, $currentId);
$genres = $data['pageProps']['types'] ?? [];
$bookList = $data['pageProps']['bookList'] ?? [];
$totalPages = $data['pageProps']['pages'] ?? 1;
$totalBooks = ($totalPages * count($bookList));

function genresView() {
    global $bohoDrama;

    if (!isset($bohoDrama) || !$bohoDrama) {
        exit();
    }
}

$genreName = "All Genres";
foreach ($genres as $genre) {
    if ($genre['id'] == $id) {
        $genreName = $genre['name'];
        break;
    }
}
$pageTitle = "$genreName ($totalBooks Titles) Page $currentId - $siteName";

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?></title>
<link rel="icon" type="image/png" href="/icon.png">
<link rel="apple-touch-icon" href="/icon.png">
<link rel="icon" type="image/png" sizes="192x192" href="/icon.png">
    <link rel="manifest" href="/manifest.json">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #121212;
            color: #ffffff;
        }
        .genre-btn {
            background-color: #1e1e1e;
            color: #ffffff;
            border: 1px solid #333;
            transition: background-color 0.3s, color 0.3s;
        }
        .genre-btn:hover {
            background-color: #e50914;
            color: #ffffff;
        }
        .book-item {
            background-color: #1e1e1e;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 15px;
            color: #ffffff;
        }
        .book-item img {
            width: 100%;
            border-radius: 8px;
        }
        .pagination-container {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 5px;
            flex-wrap: wrap;
        }
        .pagination-container a {
            text-decoration: none;
            padding: 8px 12px;
            border-radius: 5px;
            border: 1px solid #fff;
            color: #fff;
            transition: background-color 0.3s, color 0.3s;
        }
        .pagination-container a:hover {
            background-color: #e50914;
            border-color: #e50914;
        }
        .pagination-container .active {
            background-color: #e50914;
            color: #fff;
            pointer-events: none;
        }
        .pagination-container .disabled {
            background-color: #444;
            color: #aaa;
            pointer-events: none;
        }
    </style>

    <?php if (!empty($headerScripts)): 
echo $headerScripts;
    endif; ?>

</head>
<body>
<div class="container py-5">
    <h1 class="text-center mb-4">Genre: <?= htmlspecialchars($genreName) ?> (<?= $totalBooks ?> Titles)</h1>

<?php include 'nav.php'; ?>
<?php genresView(); ?>

    <!-- Genre Dropdown -->
    <div class="mb-4">
        <select class="form-select" onchange="window.location.href='/genres/' + this.value + '/1'">
            <?php foreach ($genres as $genre): ?>
                <option value="<?= $genre['id'] ?>" <?= $genre['id'] == $id ? 'selected' : '' ?>>
                    <?= htmlspecialchars($genre['name'] === 'all' ? 'All Genres' : $genre['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <!-- Book List -->
    <div class="row">
        <?php foreach ($bookList as $book): ?>
            <div class="col-md-4">
                <div class="book-item">
                    <a href="/ep/<?= htmlspecialchars($book['bookId']) ?>/<?= htmlspecialchars($book['bookNameLower']) ?>/1">
                        <img src="<?= htmlspecialchars($book['cover'] ?? 'placeholder.jpg') ?>" alt="<?= htmlspecialchars($book['bookName'] ?? 'No Title') ?>">
                    </a>
                    <h5 class="mt-2">
                        <a href="/ep/<?= htmlspecialchars($book['bookId']) ?>/<?= htmlspecialchars($book['bookNameLower']) ?>/1" class="text-decoration-none text-white">
                            <?= htmlspecialchars($book['bookName'] ?? 'No Title') ?>
                        </a>
                    </h5>
                    <p class="small"> <?= htmlspecialchars($book['viewCountDisplay'] ?? '0') ?> views | <?= htmlspecialchars($book['chapterCount'] ?? '0') ?> Episodes</p>
                    <p class="small"> <?= htmlspecialchars(substr($book['introduction'] ?? 'No description available.', 0, 200)) ?>...</p>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Pagination -->
    <div class="pagination-container mt-4">
        <?php if ($currentId > 1): ?>
            <a href="/genres/<?= $id ?>/<?= $currentId - 1 ?>" class="prev">Previous</a>
        <?php else: ?>
            <span class="disabled">Previous</span>
        <?php endif; ?>

        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <a href="/genres/<?= $id ?>/<?= $i ?>" class="<?= $i == $currentId ? 'active' : '' ?>">
                <?= $i ?>
            </a>
        <?php endfor; ?>

        <?php if ($currentId < $totalPages): ?>
            <a href="/genres/<?= $id ?>/<?= $currentId + 1 ?>" class="next">Next</a>
        <?php else: ?>
            <span class="disabled">Next</span>
        <?php endif; ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <?php if (!empty($footerScripts)): 
echo $footerScripts;
    endif; ?>

</body>
</html>
