<?php
require_once __DIR__ . '/settings.php';

$apiUrl = $dramaApi . "/" . $language . ".json";
$response = @file_get_contents($apiUrl);

if ($response) {
    $data = json_decode($response, true);

    if ($data && isset($data['pageProps']['bigList'])) {
        $bigList = $data['pageProps']['bigList'];

$history = isset($_COOKIE['history']) ? json_decode($_COOKIE['history'], true) : [];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Watch History - <?= $siteName ?></title>
<link rel="icon" type="image/png" href="/icon.png">
<link rel="apple-touch-icon" href="/icon.png">
<link rel="icon" type="image/png" sizes="192x192" href="/icon.png">
    <link rel="manifest" href="/manifest.json">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #121212;
            color: #ffffff;
        }
        .genre-btn {
            background-color: #1e1e1e;
            color: #ffffff;
            border: 1px solid #333;
            transition: background-color 0.3s, color 0.3s;
        }
        .genre-btn:hover {
            background-color: #e50914;
            color: #ffffff;
        }
        .book-item {
            background-color: #1e1e1e;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 15px;
            color: #ffffff;
        }
        .book-item img {
            width: 100%;
            border-radius: 8px;
        }
        .pagination-container {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 5px;
            flex-wrap: wrap;
        }
        .pagination-container a {
            text-decoration: none;
            padding: 8px 12px;
            border-radius: 5px;
            border: 1px solid #fff;
            color: #fff;
            transition: background-color 0.3s, color 0.3s;
        }
        .pagination-container a:hover {
            background-color: #e50914;
            border-color: #e50914;
        }
        .pagination-container .active {
            background-color: #e50914;
            color: #fff;
            pointer-events: none;
        }
        .pagination-container .disabled {
            background-color: #444;
            color: #aaa;
            pointer-events: none;
        }
        .recommendations {
            margin-top: 30px;
        }
        .recommendations h2 {
            font-size: 18px;
            color: #ffffff;
            margin-bottom: 15px;
        }
        .recommendations .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 20px;
        }
        .recommendations .card {
            background-color: #1e1e1e;
            padding: 10px;
            border-radius: 8px;
            text-align: center;
        }
        .recommendations .card img {
            width: 100%;
            border-radius: 8px;
        }
        .recommendations .card h3 {
            font-size: 14px;
            color: #ffffff;
            margin: 10px 0;
        }
        .recommendations .card p {
            font-size: 12px;
            color: #bbbbbb;
        }
    </style>

    <?php if (!empty($headerScripts)): 
echo $headerScripts;
    endif; ?>

</head>
<body>
<div class="container py-5">
    <h1 class="text-center mb-4">Watch History</h1>
    <?php include 'nav.php'; ?>

        <section class="recommendations">
            <div class="grid">
        <?php if (empty($history)): ?>
<p style="text-align: center;">You haven't watched any drama yet. Please start watching <a href="/genres/">here!</a></p>

        <?php else: ?>
            <?php foreach ($history as $item): ?>
                    <div class="card">
                    <a href="<?= htmlspecialchars($item['url']); ?>">
                        <img src="<?= htmlspecialchars($item['image']); ?>" alt="<?= htmlspecialchars($item['title']); ?>">
                        <h3><?= htmlspecialchars($item['title']); ?></h3>
                    </a>
                    </div>
                <?php endforeach; ?>
        <?php endif; ?>

            </div>
        </section>

    <?php
        $sections = [
            ['title' => 'Must Watch', 'data' => $data['pageProps']['smallData'][0]['items'] ?? []],
            ['title' => 'Trending', 'data' => $data['pageProps']['smallData'][1]['items'] ?? []],
            ['title' => 'Must Love', 'data' => $data['pageProps']['smallData'][2]['items'] ?? []],
        ];

        foreach ($sections as $section):
    ?>
        <section class="recommendations">
            <h2 class='section-title'><?= htmlspecialchars($section['title']) ?></h2>
            <div class="grid">
                <?php foreach ($section['data'] as $item): ?>
                    <div class="card">
                        <a href="/ep/<?= urlencode($item['bookId']) ?>/<?= urlencode($item['bookNameLower']) ?>/1">
                            <img src="<?= htmlspecialchars($item['cover']) ?>" alt="<?= htmlspecialchars($item['name']) ?>">
                            <h3><?= htmlspecialchars($item['name']) ?></h3>
                        </a>
                        <p><?= htmlspecialchars($item['viewCountDisplay'] ?? '0') ?> views | <?= htmlspecialchars($item['chapterCount']) ?> Episodes</p>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    <?php endforeach; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <?php if (!empty($footerScripts)): 
echo $footerScripts;
    endif; ?>

</body>
</html>
<?php
    } else {
        echo "<p>Data not available or an error occurred while processing the API.</p>";
    }
} else {
    echo "<p>Failed to retrieve data from the API.</p>";
}
?>
