<?php
$pathGambar = $_GET['path'] ?? '';

if (empty($pathGambar)) {
    header("HTTP/1.0 404 Not Found");
    exit("Invalid image path");
}

$domainBaru = "https://sres.dramaboxdb.com"; // Ubah ke domain target
$urlGambarBaru = $domainBaru . '/' . $pathGambar;

// file_put_contents('debug.log', "Path Gambar: $pathGambar\nURL Target: $urlGambarBaru\n", FILE_APPEND);

$gambarContent = @file_get_contents($urlGambarBaru);

if ($gambarContent === false) {
    header("HTTP/1.0 404 Not Found");
    exit("Gambar tidak ditemukan");
}

$finfo = new finfo(FILEINFO_MIME_TYPE);
$contentType = $finfo->buffer($gambarContent) ?: 'application/octet-stream';

header("Content-Type: $contentType");
header("Cache-Control: max-age=3600"); // Cache selama 1 jam

echo $gambarContent;
