<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['register_license'])) {
    $license = htmlspecialchars($_POST['license']);
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $password = htmlspecialchars($_POST['password']);
    $hostname = $_SERVER['HTTP_HOST'];

function get_main_domain($host) {
    $public_suffixes = [
        'web.id', 'my.id', 'biz.id', 'name.my', 'in.th', 'name.vn', 'name.in', 'me.jp', 'pe.kr', 'idv.tw', 'idv.hk'
    ];
    
    $parts = explode('.', $host);
    $count = count($parts);

    if ($count < 2) {
        return $host; // Jika tidak ada domain utama
    }

    foreach ($public_suffixes as $suffix) {
        $suffix_parts = explode('.', $suffix);
        $suffix_count = count($suffix_parts);

        if ($count > $suffix_count && array_slice($parts, -$suffix_count) === $suffix_parts) {
            return $parts[$count - $suffix_count - 1] . '.' . implode('.', $suffix_parts);
        }
    }

    return $parts[$count - 2] . '.' . $parts[$count - 1];
}

if (strpos($hostname, 'www.') === 0) {
    $hostname = substr($hostname, 4);
}

$main_domain = get_main_domain($hostname);

    $api_url = "https://member.jasadigital.web.id/sejoli-license/";

    $post_data = [
        'user_email' => $email,
        'user_pass' => $password,
        'license' => $license,
        'string' => $main_domain
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $response_html = '';

    if ($http_code === 200) {
        $result = json_decode($response, true);

        if (isset($result['valid']) && $result['valid'] === true) {
            $response_html = '<div class="response-message success">' . $result['messages'][0] . '</div>';
        } else {
            $response_html = '<div class="response-message error">' . ($result['messages'][0] ?? 'License registration failed!') . '</div>';
        }
    } else {
        $response_html = '<div class="response-message error">Failed to contact the license server. Please try again later.</div>';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Activation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #121212;
            color: #e0e0e0;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .form-container {
            background-color: #1e1e1e;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.4);
            width: 100%;
            max-width: 450px;
            box-sizing: border-box;
        }

        .form-container h1 {
            text-align: center;
            font-size: 28px;
            margin-bottom: 10px;
        }

        .form-container p {
            text-align: center;
            margin-bottom: 20px;
            font-size: 14px;
            line-height: 1.5;
            color: #ccc;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #333;
            border-radius: 5px;
            background-color: #2a2a2a;
            color: #e0e0e0;
            font-size: 14px;
        }

        .form-group input:focus {
            outline: none;
            border-color: #3a86ff;
        }

        .form-group button {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            border: none;
            border-radius: 5px;
            background-color: #3a86ff;
            color: #fff;
            cursor: pointer;
        }

        .form-group button:hover {
            background-color: #2d6cdf;
        }

        .response-message {
            margin-top: 20px;
            padding: 15px;
            border-radius: 5px;
            font-size: 14px;
            text-align: center;
        }

.response-message.success {
    background-color: #28a745;
    color: #fff;
}

        .response-message.error {
            background-color: #ff3333;
            color: #fff;
        }

.response-message.error a {
    color: #ffc107;
    text-decoration: underline;
}

.response-message.error a:hover {
    color: #ffa500;
    text-decoration: none;
}

        @media (max-width: 500px) {
            .form-container {
                padding: 20px;
            }

            .form-group input,
            .form-group button {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="form-container">
        <h1>BOHODrama License Activation</h1>
        <p>Please activate your license for this domain (<?php echo $_SERVER['HTTP_HOST']; ?>) to access the full features of the script. Make sure to enter the correct details.</p>

        <?php if (isset($response_html)) {
            echo $response_html;
        } ?>

        <!-- Form Registrasi -->
        <form method="POST" action="">
            <div class="form-group">
                <label for="license">License Key</label>
                <input type="text" id="license" name="license" placeholder="Enter your license key" value="<?= isset($license) ? htmlspecialchars($license) : ''; ?>" required>
            </div>
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" placeholder="Enter your email" value="<?= isset($email) ? htmlspecialchars($email) : ''; ?>" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" placeholder="Enter your password" value="<?= isset($password) ? htmlspecialchars($password) : ''; ?>" required>
            </div>
            <div class="form-group">
                <button type="submit" name="register_license">Activate License</button>
            </div>
        </form>
    </div>
</body>
</html>
