<style>
#installButton {
      display: none;
    position: fixed;
    bottom: 60px; /* Naikkan tombol agar tidak menutupi navbar */
    left: 10px; /* Pindahkan ke kiri */
    padding: 12px 20px;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 14px;
    z-index: 9999; /* Pastikan tetap di atas navbar */
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}
    .navbar {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background-color: #1e1e1e;
        padding: 10px;
        position: fixed;
        width: 100%;
        bottom: 0;
        left: 0;
        z-index: 1000;
    }

    .navbar a {
        color: #fff;
        text-decoration: none;
        padding: 5px 10px;
        margin: 0 auto;
        transition: background-color 0.2s;
    }

    .navbar a:hover {
        background-color: #e91e63;
        border-radius: 8px;
    }

@media (min-width: 1024px) {
    .navbar {
        max-width: 1200px; /* Batasi lebar maksimum */
        margin: 0 auto; /* Pusatkan navbar */
        left: unset; /* Hilangkan posisi fixed kiri */
        right: unset; /* Hilangkan posisi fixed kanan */
    }

    .navbar a {
        margin: 0 10px; /* Tambahkan jarak antar link */
    }
}

    .share-menu {
        position: relative;
        display: inline-block;
    }

    .share-dropdown {
        display: none;
        position: absolute;
        bottom: 50px;
        left: -50%;
        background-color: #1e1e1e;
        border: 1px solid #333;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        z-index: 2000;
    }

    .share-dropdown a {
        display: block;
        color: #fff;
        padding: 10px 15px;
        text-decoration: none;
        transition: background-color 0.2s;
    }

    .share-dropdown a:hover {
        background-color: #e91e63;
        border-radius: 4px;
    }

    .share-menu:hover .share-dropdown {
        display: block;
    }

    .search-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.8);
        z-index: 1000;
        justify-content: center;
        align-items: center;
    }

    .search-box {
        background: #fff;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        text-align: center;
        width: 90%;
        max-width: 400px;
    }

    .search-box input {
        width: 80%;
        padding: 10px;
        font-size: 16px;
        border: 1px solid #ccc;
        border-radius: 8px;
        margin-bottom: 10px;
    }

    .search-box button {
        background-color: #e91e63;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 16px;
    }

    .search-box button:hover {
        background-color: #d81b60;
    }

    .search-box .close-btn {
        background-color: #ccc;
        color: black;
        margin-top: 10px;
    }
</style>

<button id="installButton"><?= $appInstallText ?></button>

<nav class="navbar">
    <a href="/">Home</a>
    <a href="/genres/">Genres</a>
    <a href="/history/">you</a>
    <a href="javascript:void(0)" onclick="openSearch()">
<button aria-label="Search" title="Search">🔍</button>
</a>
    <div class="share-menu">
        <a href="javascript:void(0)">
<button aria-label="Share" title="Share">📤</button>
</a>
        <div class="share-dropdown">
            <a id="share-facebook" target="_blank">Facebook</a>
            <a id="share-twitter" target="_blank">X (Twitter)</a>
            <a id="share-whatsapp" target="_blank">WhatsApp</a>
            <a id="share-telegram" target="_blank">Telegram</a>
            <a href="javascript:void(0)" onclick="copyToClipboard()">Copy Link</a>
        </div>
    </div>
<div class="share-menu">
    <a href="javascript:void(0)">
<button aria-label="Change Language" title="Change Language">🌐</button>
</a>
    <div class="share-dropdown">
        <a href="?local=en">English</a>
        <a href="?local=zhHans">Simplified Chinese</a>
        <a href="?local=ko">Korean</a>
        <a href="?local=zh">Traditional Chinese</a>
        <a href="?local=es">Spanish</a>
        <a href="?local=in">Indonesia</a>
        <a href="?local=ja">Japanese</a>
        <a href="?local=de">German</a>
        <a href="?local=fr">French</a>
        <a href="?local=pt">Portuguese</a>
        <a href="?local=ar">Arabic</a>
        <a href="?local=th">Thai</a>
        <a href="?local=tl">Tagalog</a>
    </div>
</div>
</nav>

<!-- Search Popup Overlay -->
<div class="search-overlay" id="searchOverlay">
    <div class="search-box">
        <h2>Search</h2>
        <input type="text" id="searchInput" placeholder="Enter your search term..." />
        <br />
        <button onclick="performSearch()">Search</button>
        <br />
        <button class="close-btn" onclick="closeSearch()">Close</button>
    </div>
</div>

<script>
    // Mengambil URL halaman saat ini
    const currentURL = window.location.href;

    // Mengatur tautan berbagi dengan URL dinamis
    document.getElementById('share-facebook').href = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(currentURL)}`;
    document.getElementById('share-twitter').href = `https://twitter.com/intent/tweet?url=${encodeURIComponent(currentURL)}&text=Check%20this%20out!`;
    document.getElementById('share-whatsapp').href = `https://wa.me/?text=Check%20this%20out!%20${encodeURIComponent(currentURL)}`;
    document.getElementById('share-telegram').href = `https://t.me/share/url?url=${encodeURIComponent(currentURL)}&text=Check%20this%20out!`;

    // Fungsi salin tautan
    function copyToClipboard() {
        const dummyInput = document.createElement("input");
        dummyInput.value = currentURL; // Gunakan current URL
        document.body.appendChild(dummyInput);
        dummyInput.select();
        document.execCommand("copy");
        document.body.removeChild(dummyInput);
        alert("Link copied to clipboard!");
    }

    // Open the search popup
    function openSearch() {
        document.getElementById('searchOverlay').style.display = 'flex';
    }

    // Close the search popup
    function closeSearch() {
        document.getElementById('searchOverlay').style.display = 'none';
    }

    // Perform the search and redirect to the URL
    function performSearch() {
        const searchInput = document.getElementById('searchInput').value.trim();
        if (searchInput) {
            const encodedSearchTerm = encodeURIComponent(searchInput);
            window.location.href = `/search/${encodedSearchTerm}/1`;
        } else {
            alert('Please enter a search term.');
        }
    }
</script>

<script>
let deferredPrompt; // Variable to store the beforeinstallprompt event
// Listen for the beforeinstallprompt event
window.addEventListener('beforeinstallprompt', (e) => {
  // Prevent the default prompt
  e.preventDefault();
  // Save the event so it can be triggered later
  deferredPrompt = e;
  // Show the install button
  document.getElementById('installButton').style.display = 'block';
});
// Handle the install button click
document.getElementById('installButton').addEventListener('click', () => {
  // Hide the install button
  document.getElementById('installButton').style.display = 'none';
  // Show the install prompt
  deferredPrompt.prompt();
  // Wait for the user to respond to the prompt
  deferredPrompt.userChoice.then((result) => {
    if (result.outcome === 'accepted') {
      console.log('User accepted the install prompt');
    } else {
      console.log('User dismissed the install prompt');
    }
    deferredPrompt = null;
  });
});
</script>
