<?php
require_once __DIR__ . '/settings.php';

$query = isset($_GET['query']) && !empty(trim($_GET['query'])) ? trim($_GET['query']) : 'suara'; // Default query "suara"
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

$apiUrl = $dramaApi . "/" . $language . "/search.json";

$response = file_get_contents("$apiUrl?searchValue=" . urlencode($query) . "&page=" . $page);
$data = json_decode($response, true);

$totalPages = $data['pageProps']['totalPage'] ?? 0;
$currentPage = $data['pageProps']['pageNo'] ?? 1;
$bookList = $data['pageProps']['bookList'] ?? [];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Result for: "<?= htmlspecialchars($query) ?>" - <?= $siteName ?></title>
<link rel="icon" type="image/png" href="/icon.png">
<link rel="apple-touch-icon" href="/icon.png">
<link rel="icon" type="image/png" sizes="192x192" href="/icon.png">
    <link rel="manifest" href="/manifest.json">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #121212;
            color: #ffffff;
        }
        .book-item {
            background-color: #1e1e1e;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 15px;
            color: #ffffff;
        }
        .book-item img {
            width: 100%;
            border-radius: 8px;
        }
        .recommendations {
            margin-top: 30px;
        }
        .recommendations h2 {
            font-size: 18px;
            color: #ffffff;
            margin-bottom: 15px;
        }
        .recommendations .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 20px;
        }
        .recommendations .card {
            background-color: #1e1e1e;
            padding: 10px;
            border-radius: 8px;
            text-align: center;
        }
        .recommendations .card img {
            width: 100%;
            border-radius: 8px;
        }
        .recommendations .card h3 {
            font-size: 14px;
            color: #ffffff;
            margin: 10px 0;
        }
        .recommendations .card p {
            font-size: 12px;
            color: #bbbbbb;
        }
    </style>

    <?php if (!empty($headerScripts)): 
echo $headerScripts;
    endif; ?>

</head>
<body>
<div class="container py-5">
    <h1 class="text-center mb-4">Search Result for:  "<?= htmlspecialchars($query) ?>"</h1>
<?php include 'nav.php'; ?>

    <!-- Search Bar -->
    <form action="/search/<?= urlencode($query) ?>/1" method="get" class="mb-4">
        <div class="input-group">
            <input type="text" class="form-control" placeholder="Search..." value="<?= htmlspecialchars($query) ?>" oninput="this.form.action='/search/' + encodeURIComponent(this.value) + '/1';">
            <button type="submit" class="btn btn-primary">Search</button>
        </div>
    </form>

    <!-- Book List -->
    <?php if (!empty($bookList)): ?>
        <div class="row">
            <?php foreach ($bookList as $item): ?>
                <div class="col-md-4">
                    <div class="book-item">
                        <a href="/ep/<?= urlencode($item['bookId']) ?>/<?= urlencode($item['bookNameLower']) ?>/1">
                            <img src="<?= htmlspecialchars($item['coverCutWap']) ?>" alt="<?= htmlspecialchars($item['bookName']) ?>">
                        </a>
                        <a href="/ep/<?= urlencode($item['bookId']) ?>/<?= urlencode($item['bookNameLower']) ?>/1" class="text-decoration-none text-white">
                            <h5 class="mt-2"><?= htmlspecialchars($item['bookName']) ?> (<?= htmlspecialchars($item['totalChapterNum']) ?> Episodes)</h5>
                        </a>
                        <p class="small">
                            <?= htmlspecialchars(substr($item['introduction'], 0, 200)) ?>...
                        </p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p class="text-center text-muted">No results found for "<?= htmlspecialchars($query) ?>".</p>
    <?php endif; ?>

    <!-- Pagination -->
    <div class="pagination-container">
        <?php if ($currentPage > 1): ?>
            <a href="/search/<?= urlencode($query) ?>/<?= $currentPage - 1 ?>" class="btn btn-secondary">Previous</a>
        <?php endif; ?>
        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <a href="/search/<?= urlencode($query) ?>/<?= $i ?>" class="btn <?= $i == $currentPage ? 'btn-primary' : 'btn-secondary' ?>">
                <?= $i ?>
            </a>
        <?php endfor; ?>
        <?php if ($currentPage < $totalPages): ?>
            <a href="/search/<?= urlencode($query) ?>/<?= $currentPage + 1 ?>" class="btn btn-secondary">Next</a>
        <?php endif; ?>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <?php if (!empty($footerScripts)): 
echo $footerScripts;
    endif; ?>

</body>
</html>
