<?php
// Cek apakah ekstensi tertentu diaktifkan
function check_extension($name) {
    return extension_loaded($name) ? '<span class="text-success">Enabled</span>' : '<span class="text-danger">Disabled</span>';
}

// Buat file phpinfo jika diperlukan
if (isset($_GET['phpinfo'])) {
    ob_start();
    phpinfo();
    $phpinfo = ob_get_clean();
    file_put_contents('phpinfo.html', $phpinfo);
    header("Location: phpinfo.html");
    exit;
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP System Info</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            margin-top: 30px;
        }
        .card {
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
        }
        iframe {
            width: 100%;
            height: 600px;
            border: none;
        }
    </style>
</head>
<body>

<div class="container">
    <h2 class="text-center mb-4">PHP System Info</h2>
    
    <div class="row">
        <div class="col-md-6">
            <div class="card p-3 mb-3">
                <h5>PHP Version</h5>
                <p><?php echo PHP_VERSION; ?></p>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card p-3 mb-3">
                <h5>Server Software</h5>
                <p><?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card p-3 mb-3">
                <h5>cURL Support</h5>
                <p><?php echo check_extension('curl'); ?></p>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card p-3 mb-3">
                <h5>GD Library Support</h5>
                <p><?php echo check_extension('gd'); ?></p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card p-3 mb-3">
                <h5>OpenSSL Support</h5>
                <p><?php echo check_extension('openssl'); ?></p>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card p-3 mb-3">
                <h5>Memory Limit</h5>
                <p><?php echo ini_get('memory_limit'); ?></p>
            </div>
        </div>
    </div>

    <div class="text-center mt-4">
        <a href="?phpinfo=1" class="btn btn-primary">Lihat phpinfo()</a>
    </div>

    <?php if (file_exists('phpinfo.html')): ?>
    <div class="mt-4 card p-3">
        <h5>Detail phpinfo()</h5>
        <iframe src="phpinfo.html"></iframe>
    </div>
    <?php endif; ?>

</div>

</body>
</html>
