<?php
require_once __DIR__ . '/settings.php';

// Fungsi untuk mengambil data konten berdasarkan halaman (genre ID 0)
function fetchContentByPage($page) {
    global $dramaApi, $local;
    $endpointPage = $page == 1 ? 0 : $page; // Halaman pertama biasanya 0
    $endpoint = $dramaApi . "/" . $local . "/genres/0/$endpointPage.json";
    $response = file_get_contents($endpoint);
    return json_decode($response, true);
}

// Ambil halaman dari URL
$urlPath = explode('/', trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/'));
$page = isset($urlPath[1]) ? (int) str_replace('.xml', '', $urlPath[1]) : 1;

if (!$page) {
    http_response_code(404);
    exit('<h1>404 Not Found</h1>');
}

// Ambil data konten dari API
$data = fetchContentByPage($page);
$bookList = $data['pageProps']['bookList'] ?? [];

// Header untuk sitemap XML
header('Content-Type: application/xml; charset=utf-8');

// Generate sitemap page
echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
foreach ($bookList as $book) {
    $bookUrl = 'https://' . $_SERVER['HTTP_HOST'] . '/ep/' . htmlspecialchars($book['bookId']) . '/' . htmlspecialchars($book['bookNameLower']) . '/1';
    echo '<url>';
    echo '<loc>' . $bookUrl . '</loc>';
    echo '<lastmod>' . date('Y-m-d') . '</lastmod>';
    echo '</url>';
}
echo '</urlset>';
?>
