<?php
require_once __DIR__ . '/settings.php';

// Fungsi untuk mengambil total halaman dari genre ID 0
function fetchTotalPages() {
    global $dramaApi, $local;
    $endpoint = $dramaApi . "/" . $local . "/genres/0/0.json"; // Halaman pertama genre ID 0
    $response = file_get_contents($endpoint);
    $data = json_decode($response, true);
    return $data['pageProps']['pages'] ?? 1; // Total halaman
}

// Ambil total halaman untuk genre ID 0
$totalPages = fetchTotalPages();

// Header untuk sitemap XML
header('Content-Type: application/xml; charset=utf-8');

// Generate sitemap index
echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
for ($page = 1; $page <= $totalPages; $page++) {
    echo '<sitemap>';
    echo '<loc>https://' . $_SERVER['HTTP_HOST'] . '/sitemap/' . $page . '.xml</loc>';
    echo '</sitemap>';
}
echo '</sitemapindex>';
?>
