<?php
$url = "https://dramaboxdb.com";

$response = @file_get_contents($url);
if ($response === FALSE) {
    $buildIdFull = "dramaboxdb_prod_2025040819";
    echo "Gagal mengambil data dari URL, gunakan nilai default.\n";
} else {
    if (preg_match('/"buildId"\s*:\s*"([^"]+)"/', $response, $matches)) {
        $buildIdFull = $matches[1];
    } else {
        $buildIdFull = "dramaboxdb_prod_2025040819";
        echo "buildId tidak ditemukan, gunakan nilai default.\n";
    }
}

$parts = explode('_', $buildIdFull);
$buildIdValue = end($parts);

$fileName = "update.json";
$data = [];

if (file_exists($fileName)) {
    $jsonContent = file_get_contents($fileName);
    $data = json_decode($jsonContent, true);
    if (!$data) {
        $data = [];
    }
}

$data['buildId'] = $buildIdValue;

$result = file_put_contents($fileName, json_encode($data, JSON_PRETTY_PRINT));
if ($result === false) {
    echo "Gagal menyimpan data ke {$fileName}\n";
} else {
    echo "Data berhasil disimpan di {$fileName} dengan buildId: {$buildIdValue}\n";
}
?>
