<?php
require_once __DIR__ . '/settings.php';
require_once __DIR__ . '/stream.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars("$title - Chapter $chapter"); ?></title>
<link rel="icon" type="image/png" href="/icon.png">
<link rel="apple-touch-icon" href="/icon.png">
<link rel="icon" type="image/png" sizes="192x192" href="/icon.png">
    <link rel="manifest" href="/manifest.json">
    <meta name="description" content="Nonton gratis drama pendek <?php echo htmlspecialchars("$title Chapter $chapter"); ?> <?= htmlspecialchars(substr($bookInfo["introduction"], 0, 75)) ?>" />
    <meta name="keywords" content="drama, drama pendek, <?php echo htmlspecialchars("$title"); ?>, <?php echo htmlspecialchars("$title Chapter $chapter"); ?>, drama tiktok, drama cina, drama china" />
    <meta name="author" content="<?= $sitename ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta property="og:title" content="Nonton Gratis <?php echo htmlspecialchars("$title Chapter $chapter"); ?> - Drama Pendek Full Vertion" />
    <meta property="og:description" content="Nonton gratis drama pendek <?php echo htmlspecialchars("$title Chapter $chapter"); ?> <?= htmlspecialchars(substr($bookInfo["introduction"], 0, 75)) ?>" />
<?php
        $coverPath = htmlspecialchars($bookInfo['cover']); 
        $coverPath = preg_replace("#https?://[^/]+#", "", $coverPath);

$largeImage = preg_replace('/(\.jpg).*/', '$1', $coverPath);
$poster = preg_replace('/(\.jpg).*/', '$1', $bookInfo['cover']);

?>
    <meta property="og:image" content="/img<?= $largeImage ?>" />
    <meta property="og:url" content="<?= $currentUrl ?>" />
    <meta property="og:type" content="website" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="Nonton Gratis <?php echo htmlspecialchars("$title Chapter $chapter"); ?> - Drama Pendek Full Vertion" />
    <meta name="twitter:description" content="Nonton gratis drama pendek <?php echo htmlspecialchars("$title Chapter $chapter"); ?> <?= htmlspecialchars(substr($bookInfo["introduction"], 0, 75)) ?>" />
    <meta name="twitter:image" content="/img<?= $largeImage ?>" />

    <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background-color: #121212;
      color: #ffffff;
    }
    .container {
      max-width: 1024px;
      margin: 0 auto;
      padding: 20px;
    }

    /* Kontainer video */
    .video-wrapper {
      position: relative;
      width: 100%; /* Penuh pada perangkat kecil */
      max-width: 450px; /* Maksimal di layar besar */
      margin: 0 auto; /* Pusatkan player */
      overflow: hidden; /* Pastikan tidak ada elemen keluar */
      border-radius: 8px; /* Tambahkan sudut melengkung */
      background: #000; /* Latar belakang gelap */
    }

    /* Tetapkan rasio 9:16 menggunakan padding */
    .video-wrapper::before {
      content: '';
      display: block;
      padding-top: 177.78%; /* Rasio 9:16 */
    }

    /* Video.js diatur menyesuaikan kontainer */
    .video-wrapper .video-js {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
    }

    /* Media query untuk layar besar */
    @media (min-width: 768px) {
      .video-wrapper {
        width: 40%; /* Kurangi lebar di layar besar */
        max-width: 450px; /* Tetapkan batas maksimum */
      }
    }
        .video-info {
            margin-top: 15px;
            font-size: 14px;
            color: #bbbbbb;
        }
        .video-info h1 {
            font-size: 20px;
            margin: 0 0 10px;
            color: #ffffff;
        }
        .pagination {
            text-align: center;
            margin: 20px 0;
        }
        .pagination a {
            padding: 10px 20px;
            background-color: #333;
            color: #fff;
            border-radius: 50px;
            margin: 0 15px;
            text-decoration: none;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        .pagination a:hover {
            background-color: #e91e63;
        }
        .pagination a:disabled {
            background-color: #555;
            color: #aaa;
            cursor: not-allowed;
        }
        .horizontal-scroll {
            display: flex;
            overflow-x: auto;
            gap: 10px;
        }
        .horizontal-scroll a {
            flex: 0 0 auto;
            width: 120px;
            text-align: center;
            background-color: #1e1e1e;
            border-radius: 8px;
            text-decoration: none;
            color: #ffffff;
            padding: 10px;
            transition: background-color 0.2s;
        }
        .horizontal-scroll a.active,
        .horizontal-scroll a:hover {
            background-color: #e91e63;
        }
        .horizontal-scroll img {
            width: 100%;
            border-radius: 8px;
        }

        .recommendations {
            margin-top: 30px;
        }
        .recommendations h2 {
            font-size: 18px;
            color: #ffffff;
            margin-bottom: 15px;
        }
        .recommendations .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 20px;
        }
        .recommendations .card {
            background-color: #1e1e1e;
            padding: 10px;
            border-radius: 8px;
            text-align: center;
        }
        .recommendations .card img {
            width: 100%;
            border-radius: 8px;
        }
        .recommendations .card h3 {
            font-size: 14px;
            color: #ffffff;
            margin: 10px 0;
        }
        .recommendations .card p {
            font-size: 12px;
            color: #bbbbbb;
        }

/* Kontainer iklan dari IMA */
.ima-ad-container, .ima-container {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 10000; /* Pastikan berada di layer atas */
    background: rgba(0, 0, 0, 0.8); /* Opsional: Tambahkan latar belakang gelap */
    display: flex;
    justify-content: center;
    align-items: center;
}

/* Konten video tetap di bawah iklan */
.video-js {
    position: relative;
    z-index: 1; /* Tetap di bawah kontainer iklan */
}

/* Kontainer iklan tidak terlihat ketika iklan tidak aktif */
.video-js:not(.vjs-ad-playing) .ima-ad-container {
    display: none;
}

    </style>

  <link href="https://vjs.zencdn.net/8.16.1/video-js.css" rel="stylesheet" />
<script src="https://imasdk.googleapis.com/js/sdkloader/ima3.js"></script>
<script src="https://vjs.zencdn.net/8.5.2/video.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/videojs-contrib-ads@6/dist/videojs-contrib-ads.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/videojs-ima@1/dist/videojs.ima.min.js"></script>

    <?php if (!empty($headerScripts)): 
echo $headerScripts;
    endif; ?>

</head>
<body>
    <div class="container">
<?php include 'nav.php'; ?>
        <!-- Video Player -->
        <?php watch(); ?>
        <?php if ($currentVideo): ?>
            <div class="video-wrapper">
<center>
<video id="videoPlayer" class="video-js vjs-big-play-centered" controls preload="auto" data-setup='{}'>
                    <source src="<?php echo htmlspecialchars($currentVideo); ?>" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
</center>
</div>
            <div class="video-info">
                <h1><?php echo htmlspecialchars($title); ?> - Chapter <?php echo $chapter; ?></h1>
                <p><?php echo number_format($viewCount); ?> views | <?php echo $chapterCount; ?> episodes | <button id="show-more" onclick="toggleDescription()">Show more</button></p>
    <p id="description">
        <span id="full-description" style="display:none;"><?php echo $bookInfo["introduction"]; ?></span>
    </p>
    <script>
        function toggleDescription() {
            const fullDesc = document.getElementById('full-description');
            const button = document.getElementById('show-more');
            if (fullDesc.style.display === 'none') {
                fullDesc.style.display = 'inline';
                button.textContent = 'Show less';
            } else {
                fullDesc.style.display = 'none';
                button.textContent = 'Show More';
            }
        }
    </script>    
            </div>
        <?php else: ?>
            <p>Video not available for this episode.</p>
        <?php endif; ?>

    <?php if (!empty($bannerScript)): 
echo $bannerScript;
     endif; ?>

        <!-- Episode List -->
        <section class="episode-list">
            <h2>Episodes</h2>
            <div class="horizontal-scroll">
	                <?php foreach ($chapterList as $index => $chapterItem): ?>
                    <a href="/ep/<?php echo urlencode($id); ?>/<?php echo urlencode($name); ?>/<?php echo $index + 1; ?>" 
                       class="<?php echo ($index + 1) == $chapter ? 'active' : ''; ?>">
                        <img src="<?php echo htmlspecialchars($chapterItem['cover']); ?>" alt="Chapter <?php echo $index + 1; ?>">
                        <h3>Chapter <?php echo $index + 1; ?></h3>
                    </a>
                <?php endforeach; ?>
            </div>
        </section>

        <!-- Recommended for You -->
        <section class="recommendations">
            <h2>Recommended for You</h2>
            <div class="grid">
                <?php foreach ($recommends as $recommend): ?>

                    <div class="card">
<?php 
$bookName = $recommend["bookNameEn"];
$cleanedBookName = preg_replace('/[^a-zA-Z0-9]+/', ' ', $bookName);
$cleanedBookName = preg_replace('/\s+/', '-', trim($cleanedBookName));
$cleanedBookName = strtolower($cleanedBookName);
?>
                        <a href="/ep/<?php echo urlencode($recommend["bookId"]); ?>/<?php echo urlencode($cleanedBookName); ?>/1">
                            <img src="<?php echo htmlspecialchars($recommend['cover']); ?>" alt="<?php echo htmlspecialchars($recommend['bookName']); ?>">
                            <h3><?php echo htmlspecialchars($recommend['bookName']); ?></h3>
                        </a>
                        <p><?php echo number_format($recommend['viewCount']); ?> views | <?php echo $recommend['chapterCount']; ?> Episodes</p>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    </div>

<script>
    var player = videojs('videoPlayer', {
        fluid: true,
        autoplay: false,
        preload: 'auto',
    });

var vastUrl = '<?php echo htmlspecialchars($vastUrl, ENT_QUOTES, 'UTF-8'); ?>';

    var options = {
        id: 'videoPlayer',
        adTagUrl: vastUrl
    };

    player.ima(options);

    player.on('readyforpreroll', function () {
        console.log('Requesting ads...');
        player.ima.requestAds();
    });

    player.on('ads-ad-ended', function () {
        console.log('Ad ended. Playing content...');
        player.play();
    });

    const currentId = "<?php echo htmlspecialchars(isset($id) ? $id : '', ENT_QUOTES, 'UTF-8'); ?>";
    const currentName = "<?php echo htmlspecialchars(isset($name) ? $name : '', ENT_QUOTES, 'UTF-8'); ?>";
    let currentChapter = <?php echo isset($chapter) ? (int)$chapter : 1; ?>;
    const totalChapters = <?php echo isset($chapterCount) ? (int)$chapterCount : 1; ?>;
    const posterPath = "<?php echo htmlspecialchars(isset($poster) ? $poster : '', ENT_QUOTES, 'UTF-8'); ?>";

    function goToNextChapter() {
        if (currentChapter < totalChapters) {
            const nextChapter = currentChapter + 1;
            const nextUrl = `/ep/${currentId}/${currentName}/${nextChapter}`;
            console.log('Navigating to next chapter:', nextUrl);
            window.location.href = nextUrl;
        } else {
            console.log('No next chapter available.');
        }
    }

    function goToPreviousChapter() {
        if (currentChapter > 1) {
            const previousChapter = currentChapter - 1;
            const previousUrl = `/ep/${currentId}/${currentName}/${previousChapter}`;
            console.log('Navigating to previous chapter:', previousUrl);
            window.location.href = previousUrl;
        } else {
            console.log('No previous chapter available.');
        }
    }

    function addChapterButtons(player) {
        const controlBar = player.controlBar;

        const previousButton = videojs.dom.createEl('button', {
            className: 'vjs-control vjs-button',
            innerHTML: 'Prev',
        });
        previousButton.onclick = goToPreviousChapter;
        controlBar.el().insertBefore(previousButton, controlBar.el().firstChild);

        const nextButton = videojs.dom.createEl('button', {
            className: 'vjs-control vjs-button',
            innerHTML: 'Next',
        });
        nextButton.onclick = goToNextChapter;
        controlBar.el().appendChild(nextButton);
    }

    function initializePopunder(player, directLink) {
        if (directLink) {
            let popunderTriggered = false;

            player.on('play', function () {
                if (!popunderTriggered) {
                    popunderTriggered = true;
                    console.log('Popunder triggered!');
                    openPopunder(directLink);
                }
            });
        }
    }

    function openPopunder(url) {
        var newWindow = window.open(url, '_blank'); 
        if (newWindow) {
            newWindow.blur(); 
            window.focus();   
        } else {
            console.error('Popunder blocked by browser.');
        }
    }

    player.ready(function () {
        console.log('Player is ready');
    <?php if (!empty($vastUrl)): ?>

        player.ima.initializeAdDisplayContainer();
        player.one('click', function () {
            player.play();
        });
    <?php endif; ?>

        player.poster(posterPath);

        addChapterButtons(player);

        <?php if (!empty($directLink)): ?>
        const directLink = "<?php echo htmlspecialchars($directLink, ENT_QUOTES, 'UTF-8'); ?>";
        initializePopunder(player, directLink);
        <?php endif; ?>
    });
</script>

    <?php if (!empty($footerScripts)): 
echo $footerScripts;
     endif; ?>

</body>
</html>
